/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
 * \file:   ddr3.c
 *
 * \brief:  Support routines for DDR test application
 *
 * \b \Descr: This file contains the support function for DDR Test application.
 *
 */

/*
 *====================
 * Includes
 *====================
 */
#include "dm8127Board.h"
#include "ddr3.h"


/*
 *=========================
 * Function implementations
 *=========================
 */
 
 /***
 * \brief: Routine to initialize ddr3
 */

void ddr3_init( )
{
    /* TODO - ddr3 initialization to be done as part of GEL file.
     *	      Check, how to do it...
     */
}

/***
 * \brief: Routine to read from DDR3  memory
 * 
 * \b \Descr: This routine reads from DDR3 memory.This routine takes buffer pointer
 * \n         as a parameter  from where data to be read along with that it contains
 * \n         buffer to copy read data and length of the buffer.
 *
 * \param:   *pSrc  [IN]  buffer pointer to read data
 * \n        *pDSt  [IN]  buffer pointer to copy read data
 * \n        length [IN]  length of the buffer
 */
 
void ddr3_read
(
	UINT16 *pSrc,
	UINT16 *pDst,
	UINT32 length
)
{
    while (length > 0)
    {
		if (1 == length)
		{
		    *pDst = *pSrc;
	    	length--;
		}
		else
		{
		    *pDst = *pSrc;
		    pSrc++; pDst++;
	    	length -= 2;
		}
    }
}
/***
 * \brief: Routine to write into ddr3
 *
 * \b Descr: This routine writes into ddr3.This routine takes pSrc buffer pointer
 * \n        as a parameter which contains data to be copied along with that pDst
 * \n        buffer pointer  which contains the address where to copy and lenght
 * \n        of the buffer
 *
 *
 * \param:   *pSrc   [IN]   buffer to be written into ddr3
 * \n        *pDst   [IN]   address where data to be written
 * \n        length  [IN]   length of the buffer
 *
 */

void ddr3_write
(
	UINT16 *pSrc,
	UINT16 *pDst,
	UINT32 length
)
{
    while (length > 0)
    {
		if (1 == length)
		{
		    *pDst = *pSrc;
		    length--;
		}
		else
		{
		    *pDst = *pSrc;
		    pSrc++;  pDst++;
	    	length -= 2;
		}
    }
}
